Public Class TestApp
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents GroupBox2 As System.Windows.Forms.GroupBox
    Friend WithEvents grdHotels As System.Windows.Forms.DataGrid
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents lblSessionID As System.Windows.Forms.Label
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents txtPassword As System.Windows.Forms.TextBox
    Friend WithEvents txtUserName As System.Windows.Forms.TextBox
    Friend WithEvents btnLogon As System.Windows.Forms.Button
    Friend WithEvents btnBrowseSoapHeader As System.Windows.Forms.Button
    Friend WithEvents btnBrowseSession As System.Windows.Forms.Button
    Friend WithEvents btnMakeReservationSoapHeader As System.Windows.Forms.Button
    Friend WithEvents btnMakeReservationSessionID As System.Windows.Forms.Button
    Friend WithEvents btnClear As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.GroupBox2 = New System.Windows.Forms.GroupBox()
        Me.btnClear = New System.Windows.Forms.Button()
        Me.btnMakeReservationSessionID = New System.Windows.Forms.Button()
        Me.btnMakeReservationSoapHeader = New System.Windows.Forms.Button()
        Me.btnBrowseSession = New System.Windows.Forms.Button()
        Me.btnBrowseSoapHeader = New System.Windows.Forms.Button()
        Me.grdHotels = New System.Windows.Forms.DataGrid()
        Me.GroupBox1 = New System.Windows.Forms.GroupBox()
        Me.Label3 = New System.Windows.Forms.Label()
        Me.lblSessionID = New System.Windows.Forms.Label()
        Me.Label2 = New System.Windows.Forms.Label()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.txtPassword = New System.Windows.Forms.TextBox()
        Me.txtUserName = New System.Windows.Forms.TextBox()
        Me.btnLogon = New System.Windows.Forms.Button()
        Me.GroupBox2.SuspendLayout()
        CType(Me.grdHotels, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.GroupBox1.SuspendLayout()
        Me.SuspendLayout()
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.AddRange(New System.Windows.Forms.Control() {Me.btnClear, Me.btnMakeReservationSessionID, Me.btnMakeReservationSoapHeader, Me.btnBrowseSession, Me.btnBrowseSoapHeader, Me.grdHotels})
        Me.GroupBox2.Location = New System.Drawing.Point(8, 144)
        Me.GroupBox2.Name = "GroupBox2"
        Me.GroupBox2.Size = New System.Drawing.Size(592, 344)
        Me.GroupBox2.TabIndex = 8
        Me.GroupBox2.TabStop = False
        Me.GroupBox2.Text = "Steps 2 and 3: Browse and Reserve Hotel Room"
        '
        'btnClear
        '
        Me.btnClear.Location = New System.Drawing.Point(496, 56)
        Me.btnClear.Name = "btnClear"
        Me.btnClear.TabIndex = 8
        Me.btnClear.Text = "Clear Grid"
        '
        'btnMakeReservationSessionID
        '
        Me.btnMakeReservationSessionID.Location = New System.Drawing.Point(168, 272)
        Me.btnMakeReservationSessionID.Name = "btnMakeReservationSessionID"
        Me.btnMakeReservationSessionID.Size = New System.Drawing.Size(256, 23)
        Me.btnMakeReservationSessionID.TabIndex = 7
        Me.btnMakeReservationSessionID.Text = "Make Reservation (Session ID)"
        '
        'btnMakeReservationSoapHeader
        '
        Me.btnMakeReservationSoapHeader.Location = New System.Drawing.Point(168, 304)
        Me.btnMakeReservationSoapHeader.Name = "btnMakeReservationSoapHeader"
        Me.btnMakeReservationSoapHeader.Size = New System.Drawing.Size(256, 23)
        Me.btnMakeReservationSoapHeader.TabIndex = 6
        Me.btnMakeReservationSoapHeader.Text = "Make Reservation (Soap Header)"
        '
        'btnBrowseSession
        '
        Me.btnBrowseSession.Location = New System.Drawing.Point(176, 24)
        Me.btnBrowseSession.Name = "btnBrowseSession"
        Me.btnBrowseSession.Size = New System.Drawing.Size(240, 23)
        Me.btnBrowseSession.TabIndex = 5
        Me.btnBrowseSession.Text = "Browse Hotels (Session ID)"
        '
        'btnBrowseSoapHeader
        '
        Me.btnBrowseSoapHeader.Location = New System.Drawing.Point(176, 56)
        Me.btnBrowseSoapHeader.Name = "btnBrowseSoapHeader"
        Me.btnBrowseSoapHeader.Size = New System.Drawing.Size(240, 23)
        Me.btnBrowseSoapHeader.TabIndex = 4
        Me.btnBrowseSoapHeader.Text = "Browse Hotels (Soap Header)"
        '
        'grdHotels
        '
        Me.grdHotels.DataMember = ""
        Me.grdHotels.HeaderForeColor = System.Drawing.SystemColors.ControlText
        Me.grdHotels.Location = New System.Drawing.Point(16, 88)
        Me.grdHotels.Name = "grdHotels"
        Me.grdHotels.Size = New System.Drawing.Size(560, 176)
        Me.grdHotels.TabIndex = 1
        '
        'GroupBox1
        '
        Me.GroupBox1.Controls.AddRange(New System.Windows.Forms.Control() {Me.Label3, Me.lblSessionID, Me.Label2, Me.Label1, Me.txtPassword, Me.txtUserName, Me.btnLogon})
        Me.GroupBox1.Location = New System.Drawing.Point(8, 16)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(592, 112)
        Me.GroupBox1.TabIndex = 7
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Step 1: Authenticate"
        '
        'Label3
        '
        Me.Label3.Location = New System.Drawing.Point(24, 80)
        Me.Label3.Name = "Label3"
        Me.Label3.TabIndex = 12
        Me.Label3.Text = "Session ID"
        Me.Label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'lblSessionID
        '
        Me.lblSessionID.Location = New System.Drawing.Point(128, 80)
        Me.lblSessionID.Name = "lblSessionID"
        Me.lblSessionID.Size = New System.Drawing.Size(304, 23)
        Me.lblSessionID.TabIndex = 11
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(24, 48)
        Me.Label2.Name = "Label2"
        Me.Label2.TabIndex = 10
        Me.Label2.Text = "Password"
        Me.Label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(24, 24)
        Me.Label1.Name = "Label1"
        Me.Label1.TabIndex = 9
        Me.Label1.Text = "User Name"
        Me.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight
        '
        'txtPassword
        '
        Me.txtPassword.Location = New System.Drawing.Point(128, 48)
        Me.txtPassword.Name = "txtPassword"
        Me.txtPassword.PasswordChar = Microsoft.VisualBasic.ChrW(42)
        Me.txtPassword.TabIndex = 8
        Me.txtPassword.Text = ""
        '
        'txtUserName
        '
        Me.txtUserName.Location = New System.Drawing.Point(128, 24)
        Me.txtUserName.Name = "txtUserName"
        Me.txtUserName.TabIndex = 7
        Me.txtUserName.Text = ""
        '
        'btnLogon
        '
        Me.btnLogon.Location = New System.Drawing.Point(488, 72)
        Me.btnLogon.Name = "btnLogon"
        Me.btnLogon.TabIndex = 6
        Me.btnLogon.Text = "Logon"
        '
        'TestApp
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(608, 494)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.GroupBox2, Me.GroupBox1})
        Me.Name = "TestApp"
        Me.Text = "Web Service Security Demo App"
        Me.GroupBox2.ResumeLayout(False)
        CType(Me.grdHotels, System.ComponentModel.ISupportInitialize).EndInit()
        Me.GroupBox1.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub btnLogon_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLogon.Click
        Dim objAuthenticate As Authentication.Authentication

        Try
            Me.Cursor = System.Windows.Forms.Cursors.WaitCursor

            'call the authentication service
            objAuthenticate = New Authentication.Authentication()
            Me.lblSessionID.Text = objAuthenticate.Logon(Me.txtUserName.Text, Me.txtPassword.Text)


        Catch exc As System.Web.Services.Protocols.SoapException
            MsgBox(exc.Detail.OuterXml(), MsgBoxStyle.Critical, "SOAP Exception")
        Finally
            Me.Cursor = System.Windows.Forms.Cursors.Default
        End Try
    End Sub

    Private Sub btnBrowseSession_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBrowseSession.Click
        Dim objReservation As ReservationSessionID.ReservationSessionID
        Dim objResultsDataSet As DataSet

        Try
            Me.Cursor = System.Windows.Forms.Cursors.WaitCursor

            'create an instance of the web service
            objReservation = New ReservationSessionID.ReservationSessionID()

            'Call the web service method
            objResultsDataSet = objReservation.Browse(Me.lblSessionID.Text)
            Me.grdHotels.DataSource = objResultsDataSet.Tables("Hotels").DefaultView

        Catch exc As System.Web.Services.Protocols.SoapException
            MsgBox(exc.Detail.OuterXml(), MsgBoxStyle.Critical, "SOAP Exception")
        Finally
            Me.Cursor = System.Windows.Forms.Cursors.Default
        End Try
    End Sub

    Private Sub btnBrowseSoapHeader_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBrowseSoapHeader.Click
        Dim objReservation As ReservationSoapHeader.ReservationSoapHeader
        Dim objResultsDataSet As DataSet

        Try
            Me.Cursor = System.Windows.Forms.Cursors.WaitCursor

            'Create an instance of the web service
            objReservation = New ReservationSoapHeader.ReservationSoapHeader()

            'Populate the SOAP header information
            Dim objMyHeader As New ReservationSoapHeader.HotelAuthHeader()
            objMyHeader.SessionID = Me.lblSessionID.Text
            objReservation.HotelAuthHeaderValue = objMyHeader

            'Call the web service method
            objResultsDataSet = objReservation.Browse()
            Me.grdHotels.DataSource = objResultsDataSet.Tables("Hotels").DefaultView


        Catch exc As System.Web.Services.Protocols.SoapException
            MsgBox(exc.Detail.OuterXml(), MsgBoxStyle.Critical, "SOAP Exception")
        Finally
            Me.Cursor = System.Windows.Forms.Cursors.Default
        End Try
    End Sub

    Private Sub btnMakeReservationSessionID_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMakeReservationSessionID.Click
        Dim objReservation As ReservationSessionID.ReservationSessionID
        Dim intConfirmationNumber As Integer

        Try
            Me.Cursor = System.Windows.Forms.Cursors.WaitCursor
            objReservation = New ReservationSessionID.ReservationSessionID()

            'Call the web service method
            intConfirmationNumber = objReservation.MakeReservation(Me.lblSessionID.Text, Me.grdHotels.Item(Me.grdHotels.CurrentRowIndex, 0), "ABCD")
            MsgBox("Confirmation Number: " & intConfirmationNumber, MsgBoxStyle.Information, "Reservation Confirmed")
        Catch exc As System.Web.Services.Protocols.SoapException
            MsgBox(exc.Detail.OuterXml(), MsgBoxStyle.Critical, "SOAP Exception")
        Finally
            Me.Cursor = System.Windows.Forms.Cursors.Default
        End Try
    End Sub

    Private Sub btnMakeReservationSoapHeader_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMakeReservationSoapHeader.Click
        Dim objReservation As ReservationSoapHeader.ReservationSoapHeader
        Dim intConfirmationNumber As Integer

        Try
            Me.Cursor = System.Windows.Forms.Cursors.WaitCursor
            objReservation = New ReservationSoapHeader.ReservationSoapHeader()

            'Populate the SOAP header information
            Dim objMyHeader As ReservationSoapHeader.HotelAuthHeader = New ReservationSoapHeader.HotelAuthHeader()
            objMyHeader.SessionID = Me.lblSessionID.Text
            objReservation.HotelAuthHeaderValue = objMyHeader

            'Call the web service method
            intConfirmationNumber = objReservation.MakeReservation(Me.grdHotels.Item(Me.grdHotels.CurrentRowIndex, 0), "ABCD")
            MsgBox("Confirmation Number: " & intConfirmationNumber, MsgBoxStyle.Information, "Reservation Confirmed")
        Catch exc As System.Web.Services.Protocols.SoapException
            MsgBox(exc.Detail.OuterXml(), MsgBoxStyle.Critical, "SOAP Exception")
        Finally
            Me.Cursor = System.Windows.Forms.Cursors.Default
        End Try
    End Sub

    Private Sub btnClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClear.Click
        Me.grdHotels.DataSource = New DataSet()
    End Sub
End Class
